<?php 

/**
* Класс для определения пользователя
* А так же разбор адресов 
* $to = Email / ID / Null
* $EmailUser = new EmailUser($to);
* $user = $EmailUser->getUser();
* return Array()
*/
class EmailUser
{
    protected $address;
    
    public function __construct($to = null) {
        $this->address = $to;
    }
    
    /**
    * Вызов метода для определение пользователя
    * @return Callback
    */
    public function getUser() {
        $callback = $this->getAddres();
        
        return call_user_func(array($this, $callback['method']));
    }
    
    /**
    * Определение адреса
    * @return Array()
    */
    protected function getAddres() {
        if (preg_match("#^[A-z0-9-\._-]+@[A-z0-9\._-]{2,}\.[A-z]{2,8}$#ui", $this->address)) {
            $data = array('method' => 'getUserEmail');
        } elseif ($this->address === '0') {
            $data = array('method' => 'getUserSystem');
        } elseif (is_numeric($this->address) || preg_match('/^([A-z0-9-\.-_]+)$/ui', $this->address, $matches)) {
            $data = array('method' => 'getUserSite');
        } else {
            $data = array('method' => 'getUserNew');
        }
        
        return $data;
    }
    
    /**
    * Пользователь Email
    * 
    * @return Array() 
    */
    protected function getUserEmail() {
        global $config;
        
        if (preg_match("#^[A-z0-9-\._-]+@[A-z0-9\._-]{2,}\.[A-z]{2,4}$#ui", $this->address)) {
            if (in_array(strtolower(preg_replace("/.*?@/", '', $this->address)), $config['aliase'])) {
                $user = mysql_fetch_assoc(mysql_query("SELECT * FROM `user` AS u
                                                       WHERE `nick` = '" . my_esc(preg_replace("/@.*/", '', $this->address)) . "'
                                                       LIMIT 1"));
                return $this->getUserSite($user);
            }
        }
        
        return array(
            'avatar' => '<img src="style/icons/email.jpg" />', 
            'icon' => '<img src="style/icons/e.gif" />', 
            'nick' => text($this->address), 
            'link' => text($this->address), 
            'id' => $this->address, 
            'ban' => false, 
        );
    }
    
    /**
    * Пользователь сайт
    * @param undefined $user
    * 
    * @return Array()
    */
    protected function getUserSite($user = null) {
        if ($user == null) {
            $user = mysql_fetch_assoc(mysql_query("SELECT * FROM `user` AS u
                                                   WHERE `id` = '" . (int) $this->address . "' OR `nick` = '" . my_esc($this->address) . "'
                                                   LIMIT 1"));
        }
        
        if (empty($user)) {
            return $this->getUserNew();
        }
        
        /**
        * Иконка пользователя
        */
        $user['ban'] = false;
        
        if (mysql_result(mysql_query("SELECT COUNT(*) FROM `ban` WHERE `id_user` = '$user[id]' AND (`time` > '" . time() . "' OR `navsegda` = '1')"), 0) != 0) {
            $ic_id = 'ban';
            $user['ban'] = true;
        } else {
            if ($user['group_access'] > 7 && ($user['group_access'] < 10 || $user['group_access'] > 14)) {
                if ($user['pol'] == 1) {
                    $ic_id = 1;
                } else {
                    $ic_id = 2;
                }
            } elseif (($user['group_access'] > 1 && $user['group_access'] <= 7) || ($user['group_access'] > 10 && $user['group_access'] <= 14)) {
                if ($user['pol'] == 1) {
                    $ic_id = 3;
                } else {
                    $ic_id = 4;
                }
            } else {
                if ($user['pol'] == 1) {
                    $ic_id = 5;
                } else {
                    $ic_id = 6;
                }    
            }
        }
        
        $user['avatar'] = $this->getAvatar($user['id'], $user['pol']);
        $user['icon'] = '<img src="/style/user/' . $ic_id . '.png" class="icon" />';
                          
        $user['link'] = $user['icon'] . ' <a class="' . ($user['ban'] == true ? 'user-ban' : '') . '" href="/info.php?id=' . $user['id'] . '">' . $user['nick'] . '</a> ' . ($user['date_last'] > time() - 600 ? '<img src="style/icons/online.png" />' : '');
        return $user;
    }
    
    /**
    * Система сайта
    * @return Array()
    */
    protected function getUserSystem() {
        return array(
            'avatar' => '<img src="style/icons/system.png" />', 
            'icon' => '<img src="style/icons/ic_system.png" />', 
            'id' => 0, 
            'nick' => 'Система',
            'ban' => false, 
        );
    }
    
    /**
    * Если новое сообщение
    * @return Array()
    */
    protected function getUserNew() {
        return array(
            'avatar' => '', 
            'icon' => '', 
            'id' => '', 
            'ban' => false, 
            'nick' => 'Новое сообщение'
        );
    }
    
    /**
    * Определение аватара от социала или 6.6.4
    * @param undefined $id
    * @param undefined $sex
    * 
    * @return Url Avatar
    */
    protected function getAvatar($id, $sex) {
        if (is_dir(H.'sys/avatar/')) {
            if (is_file(H.'sys/avatar/' . $id . '.gif')) {
                $patch = '/sys/avatar/' . $id . '.gif';
            } elseif (is_file(H.'sys/avatar/' . $id . '.png')) {
                $patch = '/sys/avatar/' . $id . '.png';
            } elseif (is_file(H.'sys/avatar/' . $id . '.jpg')) {
                $patch = '/sys/avatar/' . $id . '.jpg';
            }
        } else {
            $avatar = mysql_fetch_assoc(mysql_query("SELECT * FROM `gallery_foto`
                                                     WHERE `id_user` = '" . $id . "' AND `avatar` = '1'
                                                     LIMIT 1"));
            
            if (isset($avatar['id'])) {
                $patch = '/foto/foto50/' . $avatar['id'] . '.' . $avatar['ras'];
            }
        }
        
        if (!isset($patch)) {
            $patch = 'style/avatar/' . $sex . '.png';
        }
        
        return '<img class="avatar" src="' . $patch . '" />';
    }
}